

export class EmailTemplateListWidget {
	
	
	tpl = `
		<div class="email-template-list-widget">
			<div class="page-header">
				<div class="toolbox">
					<a [onclick]="widget.back_Click" class="fa fa-chevron-circle-left"></a>
				</div>
				
				<h1>{{_('E-mail templates')}}</h1>
			</div>
			
			<div ez-if="loading">Loading...</div>
			<div ez-if="loading == false">
				
				<table class="table">
					<thead>
						<tr>
							<th>{{_('Template name')}}</th>
							<th>{{_('From')}}</th>
							<th>{{_('From email')}}</th>
						</tr>
					</thead>
					<tbody ez-for="templates" ez-item="t">
						<tr class="pointer" [onclick]="widget.template_Click" [t]="t">
							<td>
								{{t.name}}
							</td>
							<td>
								{{t.fromName}}
							</td>
							<td>
								{{t.fromEmail}}
							</td>
						</tr>
					</tbody>
					
					<tbody ez-if="templates.length == 0">
						<tr class="no-results-found">
							<td colspan="100%">{{_('No results found')}}</td>
						</tr>
					</tbody>
					
				</table>
			</div>
			
		</div>
	`;
	
	
	
	container = null;
	
	templates = null;
	loading = true;
	
		
	init(e) {
		this.container = e;
		
		
		this.render();
		
		this.search();
	}
	
	
	async search() {
		
		let r = await postJson('/service/email/template.do', {
			a: 'list'
		});
		
		let json = await r.json();
		
		this.templates = json.templates;
		
		this.loading = false;
		
		this.render();
		console.log(json);
	}
	
	
	render() {
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		eztpl.setVar('loading', this.loading);
		eztpl.setVar('templates', this.templates);
		
		eztpl.render();
		
	}
	
	
	
	back_Click() {
		gotoRoute( '/masterdata/' );
	}
	
	
	
	template_Click(evt, obj) {
		let t = obj.t;
		
		gotoRoute( '/email/templates/edit/?id=' + t.emailTemplateId );
	}
	
	
}



